RequireScript("Cursor.js");

function Tile()
{
	this.ASideColor = CreateColor(255, 255, 255);
	this.BSideColor = CreateColor(0  , 0  , 0  );
	this.side = 0;
	this.time = 0;
	this.w = 16; this.h = 16;
	this.x = 0; this.y = 0;
	this.step = 0;
}

Tile.prototype.flip = function()
{
	this.step = 0;
	this.time = GetTime();
}

Tile.prototype.setXY = function(x, y)
{
	this.x = x; this.y = y;
}

Tile.prototype.blit = function()
{
	if (this.step == 0)
	{
		if (this.time+2000 > GetTime())
		{
			if (this.side == 0)
			{
				this.h = this.h - (GetTime() - this.time) * this.h / 2000;
				this.y = this.y + (GetTime() - this.time) * 4 / 2000;
			}
		}
		else { this.step = 1; this.side = 1; this.time = GetTime(); }
	}
	else if (this.time+2000 > GetTime())
	{
		if (this.side == 1)
		{
			this.h = this.h - (GetTime() - this.time) * this.h / 2000;
			this.y = this.y + (GetTime() - this.time) * 4 / 2000;
		}
	}
	else this.step = 0;
	if (this.side == 0) Rectangle(this.x, this.y, this.w, this.h, this.ASideColor);
	else Rectangle(this.x, this.y, this.w, this.h, this.BSideColor);
}

function game()
{
	var myTile = new Tile();
	myTile.setXY(60, 30);
	var lBlue = CreateColor(180, 180, 255);
	while(true)
	{
		Rectangle(0, 0, GetScreenWidth(), GetScreenHeight(), lBlue);
		myTile.blit();
		if (IsMouseButtonPressed(MOUSE_LEFT) && Cursor.leftIdle)
		{
			myTile.flip();
			Cursor.leftIdle = false;
		}
		Cursor.handleUnPress();
		FlipScreen();
	}
}